USE [V5_Registry] 
GO
	--Insert Survey Information
	INSERT INTO [dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('BBS', 'BERG BALANCE SCALE', 'BERG BALANCE SCALE', 'Initial', 'Initial', GETDATE(), GETDATE());

	declare @type     int;
	SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
	FROM STD_SURVEY_TYPE
	WHERE CODE = 'BBS');

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, 'D', 'Date of assessment:', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'SITTING TO STANDING', 2, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2', 'STANDING UNSUPPORTED', 3, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3', 'SITTING WITH BACK UNSUPPORTED BUT FEET SUPPORTED ON FLOOR OR ON A STOOL', 4, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4', 'STANDING TO SITTING', 5, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5', 'TRANSFERS', 6, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6', 'STANDING UNSUPPORTED WITH EYES CLOSED', 7, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7', 'STANDING UNSUPPORTED WITH FEET TOGETHER', 8, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8', 'REACHING FORWARD WITH OUTSTRETCHED ARM WHILE STANDING', 9, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9', 'PICK UP OBJECT FROM THE FLOOR FROM A STANDING POSITION', 10, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10', 'TURNING TO LOOK BEHIND OVER LEFT AND RIGHT SHOULDERS WHILE STANDING', 11, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11', 'TURN 360 DEGREES', 12, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '12', 'PLACING ALTERNATE FOOT ON STEP OR STOOL WHILE STANDING UNSUPPORTED', 13, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '13', 'STANDING UNSUPPORTED ONE FOOT IN FRONT', 14, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '14', 'STANDING ON ONE LEG', 15, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '15', 'Total (0-56):', 16, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)


	declare @question     int, 
			@choice       int;       

	--Date Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 1)
	--Date Choice
	SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [dbo].[STD_QUESTION_CHOICE]) + 1)
	--If choice is null, meaning the choice table is empty, set it to 1
	IF @choice IS NULL SET @choice = 1
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Date', 'Date', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 1 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 2)
	--Question 1 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to stand without using hands and stabilize independently', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to stand independently using hands', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to stand using hands after several tries', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'needs minimal aid to stand or to stabilize', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs moderate or maximal assist to stand', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 2 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 3)
	--Question 2 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to stand safely 2 minutes', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to stand 2 minutes with supervision', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to stand 30 seconds unsupported', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'needs several tries to stand 30 seconds unsupported', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'unable to stand 30 seconds unassisted', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 3 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 4)
	--Question 3 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to sit safely and securely 2 minutes', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to sit 2 minutes under supervision', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to sit 30 seconds', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'able to sit 10 seconds', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'unable to sit without support 10 seconds', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 4 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 5)
	--Question 4 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'sits safely with minimal use of hands', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'controls descent by using hands', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'uses back of legs against chair to control descent', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'sits independently but has uncontrolled descent', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs assistance to sit', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 5 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 6)
	--Question 5 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to transfer safely with minor use of hands', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to transfer safely definite need of hands', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to transfer with verbal cueing and/or supervision', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'needs one person to assist', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs two people to assist or supervise to be safe', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 6 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 7)
	--Question 6 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to stand 10 seconds safely', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to stand 10 seconds with supervision', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to stand 3 seconds', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'unable to keep eyes closed 3 seconds but stays steady', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs help to keep from falling', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 7 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 8)
	--Question 7 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to place feet together independently and stand 1 minute safely', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to place feet together independently and stand for 1 minute with supervision', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to place feet together independently and to hold for 30 seconds', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'needs help to attain position but able to stand 15 seconds feet together', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs help to attain position and unable to hold for 15 seconds', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 8 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 9)
	--Question 8 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'can reach forward confidently >25 cm (10 inches)', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'can reach forward >12.5 cm safely (5 inches)', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'can reach forward >5 cm safely (2 inches)', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'reaches forward but needs supervision', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'loses balance while trying/ requires external support', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 9 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 10)
	--Question 9 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to pick up slipper safely and easily', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to pick up slipper but needs supervision', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'unable to pick up but reaches 2-5cm (1-2 inches) from slipper and keeps balance independently', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'unable to pick up and needs supervision while trying', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'unable to try/needs assist to keep from losing balance or falling', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 10 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 11)
	--Question 10 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'looks behind from both sides and weight shifts well', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'looks behind one side only other side shows less weight shift', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'turns sideways only but maintains balance', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'needs supervision when turning', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs assist to keep from losing balance or falling', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 11 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 12)
	--Question 11 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to turn 360 degrees safely in 4 seconds or less', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to turn 360 degrees safely one side only in 4 seconds or less', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to turn 360 degrees safely but slowly', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'needs close supervision or verbal cueing', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs assistance while turning', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 12 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 13)
	--Question 12 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to stand independently and safely and complete 8 steps in 20 seconds', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to stand independently and complete 8 steps >20 seconds', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to complete 4 steps without aid with supervision', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'able to complete >2 steps needs minimal assist', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'needs assistance to keep from falling/unable to try', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 13 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 14)
	--Question 13 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to place foot tandem independently and hold 30 seconds', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to place foot ahead of other independently and hold 30 seconds', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to take small step independently and hold 30 seconds', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'needs help to step but can hold 15 seconds', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'loses balance while stepping or standing', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 14 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 15)
	--Question 14 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'able to lift leg independently and hold >10 seconds', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'able to lift leg independently and hold 5-10 seconds', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'able to lift leg independently and hold = or >3 seconds', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'tries to lift leg unable to hold 3 seconds but remains standing independently', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '0', 'unable to try or needs assist to prevent fall', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 15 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'BBS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 16)
	--Question 15 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Question 15 Text', 'Question 15 Text', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

GO